<?php
/**
 * This file represents an example of the code that themes would use to register
 * the required plugins.
 *
 * It is expected that theme authors would copy and paste this code into their
 * functions.php file, and amend to suit.
 *
 * @see http://tgmpluginactivation.com/configuration/ for detailed documentation.
 *
 * @package    TGM-Plugin-Activation
 * @subpackage Example
 * @version    2.6.1 for parent theme newspotrika for publication on WordPress.org
 * @author     Thomas Griffin, Gary Jones, Juliette Reinders Folmer
 * @copyright  Copyright (c) 2011, Thomas Griffin
 * @license    http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link       https://github.com/TGMPA/TGM-Plugin-Activation
 */

require_once get_template_directory() . '/inc/class-tgm-plugin-activation.php';

add_action( 'tgmpa_register', 'newspotrika_register_required_plugins' );

function newspotrika_register_required_plugins() {

	$plugins = array(

		array(
			'name'        => esc_html__( 'Elementor', 'newspotrika' ),
			'slug'        => 'elementor',
		),
		
		array(
			'name'      => esc_html__( 'NewsPotrika Plugin', 'newspotrika' ),
			'slug'      => 'newspotrika-plugin',
			'source'    => 'https://github.com/farhan01617/newspotrika-plugin/archive/master.zip',
		)
		
	);

	$config = array(
		'id'           => 'newspotrika',
		'default_path' => '',
		'menu'         => 'tgmpa-install-plugins',
		'has_notices'  => true,
		'dismissable'  => true,
		'dismiss_msg'  => '', 
		'is_automatic' => false,
		'message'      => '',  
	);

	tgmpa( $plugins, $config );
}
