<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package newspotrika
 */

$control_top_header = get_theme_mod( 'control_top_header', true );
$newspotrika_display_ad_on_top = get_theme_mod( 'newspotrika_display_ad_on_top', true );
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link rel="profile" href="http://gmpg.org/xfn/11">

	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<div id="page" class="site">
	<a class="skip-link screen-reader-text" href="#content"><?php esc_html_e( 'Skip to content', 'newspotrika' ); ?></a>

	<header>
		<div class="site-header">
			<div class="container">
				<div class="row">
					<?php if ($control_top_header == true): ?>
					<div class="col-sm-4">
						<div class="site-branding">
							<?php
							if( has_custom_logo() ){
									the_custom_logo();
							} else { ?>
								<a class="navbar-brand" href="<?php echo esc_url( home_url() ); ?>"><?php bloginfo( 'title' ) ?></a>
								<p class="site-desc"><?php echo esc_html( get_bloginfo( 'description' ) ); ?></p>
								<?php
							}  ?>
						</div><!-- .site-branding -->
					</div>

					<?php if ($newspotrika_display_ad_on_top == true) {?>
					<div class="col-sm-8">
						<?php 
						if (is_active_sidebar('header_ad')) {
							dynamic_sidebar('header_ad');
						} ?>		
					</div>
					<?php } ?>	

					<?php endif ?>									

					<div class="col-sm-12">
						<div class="mobile_menu"></div>
					</div>
				</div>
			</div>
		</div>

		<nav class="navbar" role="navigation">
			<div class="container">
			    <div class="row newspotrika_navbar">
					<?php
					wp_nav_menu( array(
						'theme_location'    => 'primary',
						'depth'             => 2,
						'container'         => 'ul'
					) );
					?>
				</div>
			</div>
		</nav>
	</header><!-- #masthead -->



	<?php 
	if (!is_page_template( 'home-page.php')) { 
		// header bg image
		function newspotrika_header_bg_image() {
		  if (has_header_image()) { ?>
		    style="background-image: url( '<?php header_image(); ?>');"
		    <?php } else {
		    echo " ";
		  }
		} ?>
     <!-- START BREADCRUMB AREA -->
	<section class="breadcrumb-banner <?php if( has_header_image() ){ echo 'breadcrumb-bnr-shadow';} ?>" <?php newspotrika_header_bg_image() ?>>
		<div class="container">
			<div class="row">
				<div class="col-sm-12">
					<div class="breadcrumb-title">
						<h1>
						<?php
						if(is_home() && is_front_page()){
						$breadcrumb_title = !empty($newspotrika_opt['blog_breadcrumb_title']) ? $newspotrika_opt['blog_breadcrumb_title'] : esc_html__( 'Latest Posts', 'newspotrika' );
						}else if(is_home()){
						$breadcrumb_title = !empty($newspotrika_opt['blog_breadcrumb_title']) ? $newspotrika_opt['blog_breadcrumb_title'] : wp_title('', false);
						}else{
						$breadcrumb_title = wp_title('', false);
						}
						echo esc_html($breadcrumb_title);
						?>
						</h1>
						<div class="breadcrumbs">
							<?php if ( function_exists( 'newspotrika_breadcrumb' ) ) newspotrika_breadcrumb(); ?>
						</div>
					</div>
				</div>
			</div>
		</div>
	</section>
    <!--END BREADCRUMB AREA-->
	<?php } ?>
		

	<div id="content" class="site-content">
