<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package newspotrika
 */

get_header();
?>

<div class="section-padding">
	<div class="container">
		<div class="row justify-content-center">
			<div class="col-sm-<?php echo is_active_sidebar( 'sidebar' ) ? 8 : 12 ; ?>">

			<?php
			while ( have_posts() ) : the_post();
				
				get_template_part( 'template-parts/content', get_post_type() );

				the_post_navigation( array(
		            'prev_text' => esc_html__('&#171; prev post', 'newspotrika'),
		            'next_text' => esc_html__('next post &#187;', 'newspotrika')
		        ) );

				// If comments are open or we have at least one comment, load up the comment template.
				if ( comments_open() || get_comments_number() ) :
					comments_template();
				endif;

			endwhile; // End of the loop.
			?>

			</div>

			<?php if (is_active_sidebar( 'sidebar' )): ?>
			<div class="col-sm-4">
				<?php get_sidebar(); ?>
			</div>
			<?php endif ?>
			
		</div>
	</div>
</div>

<?php
get_footer();